// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityEye.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntityEye.h"
#include "EntityLaser.h"
#include "Level.h"
#include "Game.h"




EntityEye::EntityEye() :
  m_Awake( false )
{

  m_Floating = true;

  SetRect( &m_CollisionRect, 0, 0, 32, 32 );

  SetFrame( Dobbs::ANIM_EYE_SLEEP );

}



void EntityEye::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_INIT:
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



void EntityEye::UpdateTimed( Level& aLevel, float ElapsedTime )
{

  Entity::UpdateTimed( aLevel, ElapsedTime );

  if ( m_State == 1 )
  {
    if ( m_StateTime >= 3.0f )
    {
      // eye open anim should be done by now, set to permanent open animation
      SetFrame( Dobbs::ANIM_EYE_LOOK );
    }
  }
  if ( !m_Awake )
  {
    Entity*   pPlayer = aLevel.FindEntityByType( Dobbs::ENTITY_TYPE_PLAYER );
    if ( pPlayer )
    {
      if ( ( pPlayer->GetX() - m_X ) * ( pPlayer->GetX() - m_X ) + ( pPlayer->GetY() - m_Y ) * ( pPlayer->GetY() - m_Y ) < 65600 )
      {
        // close enough, eye wakes up
        Wakeup();

        aLevel.m_pGame->PreCollect( m_SpawnPosX, m_SpawnPosY );

        aLevel.m_pGame->OnGameEvent( Dobbs::GE_START_ALARM );
      }
    }
  }

}



void EntityEye::Wakeup()
{

  SetState( 1 );
  m_Awake = true;
  SetFrame( Dobbs::ANIM_EYE_OPEN );

}